function [pprisknewprofiledifft]=postprocessdiffoftwoprofiles(xnew1,xnew2,nuoflevels,psicsave,phisave,riskthetasave,iterations,maxnumberofclusters)

% THIS FUNCTION POST PROCESSES THE SAMPLED PHI'S PSI'S AND THETA'S IN
% ORDER TO ESTIMATE THE difference in the  
% RISK of two NEW PROFILEs, IN THE FOLLOWING WAY:
% a) Run the profile through all the iterations
% b) For every iteration choose the most likely cluster for this profile,
%    calculating the probability of the profile for each cluster
% c) choose the corresponding theta and save it.

pprisknewprofiledifft=zeros(iterations,1);
% if we have 100 in a profile then we do not account for the corresponding factor
xnew11=xnew1; xnew11(xnew11==100)=0;
xnew22=xnew2; xnew22(xnew22==100)=0;

xind1=xnew11(1)+1; % indicator for selecting the right elements of phisave{itemp,ictemp,:}. 
xind2=xnew22(1)+1; % indicator for selecting the right elements of phisave{itemp,ictemp,:}. 
for itemp=2:size(nuoflevels,2)
    xind1=[xind1 sum(nuoflevels(1:itemp-1))+xnew11(itemp)+1]; 
    xind2=[xind2 sum(nuoflevels(1:itemp-1))+xnew22(itemp)+1];
end

for itemp=1:iterations
    probabofx1=zeros(1,maxnumberofclusters);
    probabofx2=zeros(1,maxnumberofclusters);
    for ictemp=1:maxnumberofclusters
        phitemp=[phisave{itemp,ictemp,:}]; % creates a vector with the elements of phisave{itemp,ictemp,:}
        phitemptwo1=phitemp(1,xind1); 
        phitemptwo2=phitemp(1,xind2);
        probabofx1(1,ictemp)=prod(phitemptwo1(xnew1~=100)); % select according to xnew and 100
        probabofx2(1,ictemp)=prod(phitemptwo2(xnew2~=100)); % select according to xnew and 100
    end
    probab1=psicsave(itemp,:).*probabofx1;
    probab2=psicsave(itemp,:).*probabofx2;
    
    probab1=probab1*(sum(probab1)^(-1));  
    correct=1-sum(probab1);
    probab1(max(probab1)==probab1)=...
        probab1(max(probab1)==probab1)+correct;
    if (abs(1-sum(probab1))>1E-16)
        correct=1-sum(probab1);
        probab1(max(probab1)==probab1)=...
            probab1(max(probab1)==probab1)+correct;
    end
    
    probab2=probab2*(sum(probab2)^(-1));
    correct=1-sum(probab2);
    probab2(max(probab2)==probab2)=...
        probab2(max(probab2)==probab2)+correct;
    if (abs(1-sum(probab2))>1E-16)
        correct=1-sum(probab2);
        probab2(max(probab2)==probab2)=...
            probab2(max(probab2)==probab2)+correct;
    end
    
    tempriskvector=riskthetasave(itemp,:);
    pprisknewprofiledifft(itemp,1)=tempriskvector(logical(mnrnd(1,probab1,1))) - tempriskvector(logical(mnrnd(1,probab2,1)));
    %pprisknewprofiledifft(itemp,1)=sum(riskthetasave(itemp,:).*probab1)-sum(riskthetasave(itemp,:).*probab2); OLD WAY
end        
figure(60);
hist(pprisknewprofiledifft,1000);
mean(pprisknewprofiledifft)
median(pprisknewprofiledifft)